
#version 430 core

layout(location = 0) out float visibility;

in vec2 TexCoords;

uniform sampler2DShadow shadowMap;

uniform sampler2D geoLightPos;
uniform sampler2D blendLightPos;
uniform sampler2D biasMap;
uniform sampler2D SSDepthMap;

uniform float NearPlane;
uniform float FarPlane;
uniform float Exponential;

uniform float shadowPower = 2.00;

highp float map_01(float x, float v0, float v1)
{
 return (x - v0) / (v1 - v0);
}


highp float saturate(highp float v)
{
 return clamp(v, 0.0, 1.0);
}

vec2 poissonDisk[4] = vec2[](
 vec2( -0.94201624, -0.39906216 ),
 vec2( 0.94558609, -0.76890725 ),
 vec2( -0.094184101, -0.92938870 ),
 vec2( 0.34495938, 0.29387760 )
);

void main()
{       

	if(texture(SSDepthMap, TexCoords.xy).r == 1.0){
		discard;
	}
	
	float solidDepth = texture(geoLightPos, TexCoords.xy).z;
	float blendDepth = texture(blendLightPos, TexCoords.xy).z;

	visibility = 1.0;

	vec4 ShadowCoord;

	if(blendDepth == 0.0 && solidDepth == 0.0){
		
		discard;
	}

	if(blendDepth != 0.0){
		
		ShadowCoord = texture(blendLightPos, TexCoords.xy);
	
	}else{

		ShadowCoord = texture(geoLightPos, TexCoords.xy);

	}



	float biasMapValue = texture(biasMap, ShadowCoord.xy).r;


 float bias = 0.05 * tan(acos(biasMapValue));

 ShadowCoord.z -= clamp(bias, 0.001, 0.005) - 0.001;

 float outVisibility = 0.0;


 outVisibility = texture(shadowMap, vec3(ShadowCoord.xy, ShadowCoord.z));

 /*
 for (int i=0;i<4;i++){

	outVisibility += texture(shadowMap, vec3(ShadowCoord.xy + + poissonDisk[i]/1200.0, ShadowCoord.z));
 
}
*/
 
 visibility = outVisibility;

 
	if((ShadowCoord.x >= 1.0f || ShadowCoord.x <= 0.00f) && visibility == 0){
		visibility = 1.0;
	}
	if((ShadowCoord.y >= 1.0f || ShadowCoord.y <= 0.00f) && visibility == 0){
		visibility = 1.0;
	}
 	

}

